// Inicialización del slider de reseñas con Swiper
document.addEventListener('DOMContentLoaded', function() {
    var swiper = new Swiper('#resenha-slider', {
        effect: 'fade',
        fadeEffect: {
            crossFade: true
        },
        loop: true,
        autoplay: {
            delay: 500000,
            disableOnInteraction: false,
            pauseOnMouseEnter: true
        },
        speed: 1000,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        allowTouchMove: true
    });
    
    // Personalizar flechas con imágenes después de la inicialización
    var prevArrow = document.querySelector('#resenha-slider .swiper-button-prev');
    var nextArrow = document.querySelector('#resenha-slider .swiper-button-next');
    
    if (prevArrow && nextArrow) {
        // Limpiar contenido SVG por defecto y agregar imágenes personalizadas
        prevArrow.innerHTML = '<img src="imagenes/Flecha.svg" alt="Anterior">';
        nextArrow.innerHTML = '<img src="imagenes/Flecha.svg" alt="Siguiente">';
        
        // Rotar la flecha de siguiente
        var nextImg = nextArrow.querySelector('img');
        if (nextImg) {
            //nextImg.style.transform = 'rotate(180deg)';
        }
    }
});
