// Widget - Testimonios Bejewel con Swiper.js

document.addEventListener('DOMContentLoaded', function() {
    var slideContainer = document.getElementById('res-v3g');
    var slides = document.querySelectorAll('.slide-3pe');
    var prevButton = document.querySelector('.row-d48');
    var nextButton = document.querySelector('.row-xqp');
    var prevSelector = '.row-d48';
    var nextSelector = '.row-xqp';
    var containerElement = document.getElementById('res-clb');
    
    if (!slideContainer || slides.length === 0 || !containerElement) {
        return;
    }
    
    // Encontrar el slide activo inicial (con clase is-dzo)
    var initialSlide = 0;
    slides.forEach(function(slide, index) {
        if (slide.classList.contains('is-dzo')) {
            initialSlide = index;
        }
    });
    
    // Obtener el padding del contenedor para calcular el espacio
    var containerStyle = window.getComputedStyle(containerElement);
    var paddingLeft = parseFloat(containerStyle.paddingLeft) || 0;
    var paddingRight = parseFloat(containerStyle.paddingRight) || 0;
    
    // Asegurar que el contenedor tenga la clase correcta para Swiper
    containerElement.classList.add('swiper');
    slideContainer.classList.add('swiper-wrapper');
    slides.forEach(function(slide) {
        slide.classList.add('swiper-slide');
    });
    
    // Registrar módulos necesarios
    if (window.Swiper && Swiper.Navigation) {
        Swiper.use([Swiper.Navigation]);
    }

    // Inicializar Swiper
    var swiper = new Swiper(containerElement, {
        // Configuración básica
        slidesPerView: 'auto',
        centeredSlides: true,
        spaceBetween: 20,
        initialSlide: initialSlide,
        
        // Navegación personalizada
        navigation: {
            nextEl: nextSelector,
            prevEl: prevSelector,
        },
        
        // Efectos
        effect: 'slide',
        speed: 500,
        
        // Configuración responsive
        breakpoints: {
            // Móvil
            0: {
                slidesPerView: 1,
                spaceBetween: 0,
                centeredSlides: true,
            },
            // Tablet
            768: {
                slidesPerView: 1,
                spaceBetween: 20,
                centeredSlides: true,
            },
            // Desktop
            992: {
                slidesPerView: 1,
                spaceBetween: 20,
                centeredSlides: true,
            }
        },
        
        // Callbacks
        on: {
            init: function() {
                // Ajustar el padding del contenedor después de la inicialización
                if (window.innerWidth >= 992) {
                    containerElement.style.paddingLeft = paddingLeft + 'px';
                    containerElement.style.paddingRight = paddingRight + 'px';
                }
            },
            resize: function() {
                // Ajustar padding en resize
                if (window.innerWidth >= 992) {
                    containerElement.style.paddingLeft = paddingLeft + 'px';
                    containerElement.style.paddingRight = paddingRight + 'px';
                } else {
                    containerElement.style.paddingLeft = '0px';
                    containerElement.style.paddingRight = '0px';
                }
            }
        }
    });
});
