// Widget - Productos Destacados Bioken

document.addEventListener('DOMContentLoaded', function() {
    var currentSlide = 0;
    var slideContainer = document.getElementById('des-c36');
    var slides = document.querySelectorAll('.slide-iwf');
    var prevButton = document.querySelector('.destacados-mvi');
    var nextButton = document.querySelector('.destacados-5od');
    var totalSlides = slides.length;
    
    if (!slideContainer || totalSlides === 0) {
        return;
    }
    
    if (!prevButton || !nextButton) {
        return;
    }
    
    // Función para calcular el ancho del slide según el tamaño de pantalla
    function getSlideWidth() {
        if (slides.length === 0) return 292.5; // 262.5px + 30px margin
        
        // Obtener el ancho real del primer slide
        var firstSlide = slides[0];
        var slideRect = firstSlide.getBoundingClientRect();
        var slideWidth = slideRect.width;
        
        // Obtener el margin-right del slide
        var slideStyle = window.getComputedStyle(firstSlide);
        var marginRight = parseFloat(slideStyle.marginRight) || 0;
        
        // Retornar ancho total (ancho del elemento + margen derecho)
        return slideWidth + marginRight;
    }
    
    // Función para mover el slider
    function moveSlider(direction) {
        if (direction === 'next') {
            currentSlide = (currentSlide + 1) % totalSlides;
        } else if (direction === 'prev') {
            currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
        }
        
        var slideWidth = getSlideWidth();
        var translateX = -(currentSlide * slideWidth);
        
        // Aplicar transformación con !important para sobrescribir CSS
        slideContainer.style.setProperty('transform', 'translateX(' + translateX + 'px)', 'important');
        slideContainer.style.setProperty('transition', 'transform 0.5s ease', 'important');
    }
    
    // Inicializar posición del slider al cargar
    function initializeSlider() {
        currentSlide = 0;
        slideContainer.style.setProperty('transition', 'none', 'important');
        slideContainer.style.setProperty('transform', 'translateX(0px)', 'important');
        
        // Activar transiciones después de un breve delay
        setTimeout(function() {
            slideContainer.style.setProperty('transition', 'transform 0.5s ease', 'important');
            slideContainer.style.setProperty('transform', 'translateX(0px)', 'important');
        }, 100);
    }
    
    // Inicializar al cargar
    initializeSlider();
    
    // Recalcular al redimensionar la ventana
    window.addEventListener('resize', function() {
        var slideWidth = getSlideWidth();
        var translateX = -(currentSlide * slideWidth);
        slideContainer.style.setProperty('transform', 'translateX(' + translateX + 'px)', 'important');
    });
    
    // Event listeners para los botones
    nextButton.addEventListener('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        moveSlider('next');
        return false;
    });
    
    prevButton.addEventListener('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        moveSlider('prev');
        return false;
    });
});
