// Widget - Nuestros Profesionales - Centro Oftalmológico de Canarias

document.addEventListener('DOMContentLoaded', function() {
    var currentSlide = 0;
    var sliderContainer = document.getElementById('equ-ihj');
    var slideList = sliderContainer ? sliderContainer.querySelector('.list-13l') : null;
    var slides = slideList ? slideList.querySelectorAll('.slide-evm') : [];
    var prevButton = document.querySelector('.row-edo');
    var nextButton = document.querySelector('.row-yxx');
    var paginationButtons = document.querySelectorAll('.pagination-b8w');
    var totalSlides = slides.length;
    
    if (!sliderContainer || !slideList || totalSlides === 0) {
        return;
    }
    
    // Función para mostrar un slide específico
    function showSlide(index) {
        // Asegurar que el índice esté en el rango válido
        if (index < 0) {
            index = totalSlides - 1;
        } else if (index >= totalSlides) {
            index = 0;
        }
        
        currentSlide = index;
        
        // Detectar si estamos en móvil
        var isMobile = window.innerWidth <= 992;
        
        // Ocultar todos los slides
        slides.forEach(function(slide, i) {
            if (i === currentSlide) {
                slide.classList.add('is-ivc');
                slide.style.opacity = '1';
                slide.style.zIndex = '1';
                // En móvil, siempre usar position relative
                if (isMobile) {
                    slide.style.position = 'relative';
                    slide.style.width = '100%';
                    slide.style.height = 'auto';
                    slide.style.overflow = 'visible';
                    slide.style.left = 'auto';
                    slide.style.top = 'auto';
                } else {
                    slide.style.position = 'relative';
                }
            } else {
                slide.classList.remove('is-ivc');
                slide.style.opacity = '0';
                slide.style.zIndex = '0';
                // En móvil, ocultar completamente los slides no activos sin ocupar espacio
                if (isMobile) {
                    slide.style.position = 'absolute';
                    slide.style.left = '0';
                    slide.style.top = '0';
                    slide.style.width = '100%';
                    slide.style.height = '0';
                    slide.style.overflow = 'hidden';
                } else {
                    slide.style.position = 'absolute';
                }
            }
        });
        
        // Actualizar paginación
        paginationButtons.forEach(function(btn, i) {
            if (i === currentSlide) {
                btn.classList.add('is-ivc');
            } else {
                btn.classList.remove('is-ivc');
            }
        });
    }
    
    // Función para ir al siguiente slide
    function nextSlide() {
        showSlide(currentSlide + 1);
    }
    
    // Función para ir al slide anterior
    function prevSlide() {
        showSlide(currentSlide - 1);
    }
    
    // Event listeners para los botones de navegación
    if (nextButton) {
        nextButton.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            nextSlide();
        });
    }
    
    if (prevButton) {
        prevButton.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            prevSlide();
        });
    }
    
    // Event listeners para los botones de paginación
    paginationButtons.forEach(function(btn, index) {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            showSlide(index);
        });
    });
    
    // Inicializar el slider mostrando el primer slide
    showSlide(0);
    
    // Asegurar que los dots se posicionen correctamente después de la carga
    setTimeout(function() {
        var pagination = sliderContainer.querySelector('.pagination-bo6');
        if (pagination) {
            pagination.style.position = 'absolute';
            pagination.style.bottom = '20px';
            pagination.style.left = '50%';
            pagination.style.transform = 'translateX(-50%)';
        }
    }, 100);
    
    // Recalcular al redimensionar la ventana
    window.addEventListener('resize', function() {
        showSlide(currentSlide);
        // Reajustar posición de dots después de resize
        setTimeout(function() {
            var pagination = sliderContainer.querySelector('.pagination-bo6');
            if (pagination) {
                pagination.style.position = 'absolute';
                pagination.style.bottom = '20px';
                pagination.style.left = '50%';
                pagination.style.transform = 'translateX(-50%)';
            }
        }, 50);
    });
    
    // Auto-play opcional (descomentar si se desea)
    // var autoPlayInterval = setInterval(nextSlide, 5000);
    
    // Pausar auto-play al hacer hover
    // if (sliderContainer) {
    //     sliderContainer.addEventListener('mouseenter', function() {
    //         clearInterval(autoPlayInterval);
    //     });
    //     sliderContainer.addEventListener('mouseleave', function() {
    //         autoPlayInterval = setInterval(nextSlide, 5000);
    //     });
    // }
});
